#!/bin/sh

DOMAIN_NAME="$1"
USER_NAME=`/usr/bin/id -nu`

PHP=`which php`
DEF_PHP_VER_FILE="`$PHP -v|grep built|cut -d' ' -f2|cut -c1-3`"
DEF_MEMORY_FILE="/usr/local/php/conf/default_memory_limit"

PHP_VER_FILE="/home/$USER_NAME/.system-php/conf/$DOMAIN_NAME/php_ver"
MEMORY_FILE="/home/$USER_NAME/.system-php/conf/$DOMAIN_NAME/memory_limit"

    #Configure PHP version
    if [ $DEF_PHP_VER_FILE ]; then
    DEF_PHP_VER="$DEF_PHP_VER_FILE"
else
    DEF_PHP_VER="5.3"
fi

    if [ -s $PHP_VER_FILE ]; then
    PHP_VER=`/bin/cat $PHP_VER_FILE`
else
    PHP_VER=$DEF_PHP_VER
fi

    #Configure PHP memory limit
    if [ -s $DEF_MEMORY_FILE ]; then
    DEF_MEMORY_LIM=`/bin/cat $DEF_MEMORY_FILE`
else
    DEF_MEMORY_LIM="1G"
fi

    if [ -s $MEMORY_FILE ]; then
    MEMORY_LIM=`/bin/cat $MEMORY_FILE`
else
    MEMORY_LIM=$DEF_MEMORY_LIM
fi


    PHP_INI_SCAN_DIR="/home/$USER_NAME/.system-php/ini/$PHP_VER/$DOMAIN_NAME/"
export PHP_INI_SCAN_DIR
        PHP_FCGI_CHILDREN=0
export PHP_FCGI_CHILDREN
        PHP_FCGI_MAX_REQUESTS=1000
export PHP_FCGI_MAX_REQUESTS
        PHP_VER="`tr -d '.' <<< $PHP_VER`"
exec /opt/alt/php$PHP_VER/usr/bin/php-cgi -d memory_limit=$MEMORY_LIM
